# NC-AI-001: AI Risk Register Template - README

## Overview

**NC-AI-001** is the first published standard from the Northern Cascadia Institute of AI Governance. This AI Risk Register Template provides a comprehensive, ISO 42001-compliant framework for identifying, assessing, and managing AI-related risks in your organization.

**Version**: 1.0  
**Publication Date**: Q1 2026  
**Status**: Public Release  
**License**: Public Domain - Free for use and adaptation

---

## Available Formats

### Format Options

1. **Markdown (.md)** - `NC_AI_001_AI_Risk_Register_Template.md`
   - Primary template format
   - Best for: Version control, internal documentation, website publication
   - Fully formatted with tables, headers, and instructions

2. **CSV (.csv)** - `NC_AI_001_Risk_Register_Template.csv`
   - Spreadsheet-compatible format
   - Best for: Excel import, database integration, bulk data entry
   - Contains 28 pre-populated risk entries ready for assessment

3. **PDF** (Coming Soon)
   - Professional printable format
   - Best for: Official documentation, sharing with stakeholders
   - Will be generated from markdown source

### How to Use Each Format

**For Small Businesses**:
- Start with the **Markdown (.md)** version
- Print relevant sections or work digitally
- Fill in risk assessments in your own format

**For Large Organizations**:
- Import **CSV (.csv)** into Excel or risk management software
- Customize columns and add organization-specific risks
- Use as foundation for integrated risk management systems

**For Public Documentation**:
- Use **Markdown (.md)** for web publication
- Generate PDF for official records
- Maintain version control in markdown

---

## What's Included

### The Template Contains

- **Risk Scoring Framework**: 5x5 impact and likelihood matrices
- **28 Pre-Populated Risks**: Across 8 major categories
- **Instructions**: Step-by-step guidance for implementation
- **Control Strategies**: Example mitigation approaches
- **Review Checklist**: Ongoing assessment framework
- **Approval Tracking**: Document control and sign-off

### Risk Categories Covered

1. **Bias and Fairness** (4 risks)
   - Algorithmic bias, unfair treatment, data representativeness, stereotype reinforcement

2. **Security and Privacy** (5 risks)
   - Unauthorized access, data breaches, poisoning attacks, IP theft, access controls

3. **Transparency and Explainability** (4 risks)
   - Lack of explainability, black box decisions, inadequate communication, documentation failures

4. **Data Quality and Integrity** (4 risks)
   - Poor training data, incomplete coverage, provenance issues, model drift

5. **Regulatory Compliance** (4 risks)
   - Non-compliance, insufficient documentation, cross-jurisdictional challenges, IP infringement

6. **Operational Risks** (4 risks)
   - System failures, degraded performance, inadequate oversight, workflow disruption

7. **Human Impact and Safety** (4 risks)
   - Safety risks, psychological harm, employment displacement, misinformation

8. **Third-Party and Vendor** (4 risks)
   - Vendor breaches, lock-in, compliance issues, unclear responsibilities

---

## Quick Start Guide

### Step 1: Choose Your Format
- Markdown for comprehensive review
- CSV for spreadsheet-based assessment

### Step 2: Define Your Scope
Before assessing risks, clearly define:
- Which AI system(s) are you assessing?
- What is the intended use?
- Who are the affected stakeholders?
- What is your role? (Developer / Provider / User / Multiple)

### Step 3: Assess Risks
For each relevant risk:
1. Assign Impact score (1-5)
2. Assign Likelihood score (1-5)
3. Calculate Risk Score (Impact × Likelihood)
4. Identify existing or planned controls
5. Assign ownership and target dates

### Step 4: Prioritize Treatment
Focus on:
- **Extreme (20-25)**: Immediate action required
- **High (15-19)**: Treatment within 30 days
- **Medium (10-14)**: Treatment within 90 days

### Step 5: Implement and Monitor
- Document control implementation
- Track progress regularly
- Re-assess quarterly
- Update annually

---

## Integration with ISO 42001

### Standards Alignment

This template is designed for organizations pursuing **ISO 42001 certification**. It covers:

- **Clause 6.1.2**: Actions to address risks and opportunities
- **Annex A.2**: AI Risk Management controls
- **ISO 23894**: AI risk management guidance
- **ISO 42005**: AI impact assessments

### Certification Support

Using this template helps you:
- Document AI risk management processes
- Meet ISO 42001 documentation requirements
- Prepare for certification audits
- Maintain ongoing compliance

---

## Customization

### Adding Organization-Specific Risks

The template includes sections for:
- Industry-specific risks
- Organizational-specific risks
- Emerging and unknown risks

Add rows/categories as needed for your context.

### Adapting Risk Categories

While the 8 core categories cover most scenarios, you may need to:
- Add sector-specific risk categories (healthcare, finance, etc.)
- Include emerging risk types
- Tailor to your organizational culture
- Integrate with existing risk frameworks

---

## Support and Resources

### Getting Help

- **Documentation**: All instructions included in templates
- **Standards**: Based on ISO 42001, ISO 23894, ISO 31000
- **Support**: Email governance@kaizenstrategic.ai

### Related Standards

- **NC-AI-002**: AI Impact Assessment Framework (Coming Soon)
- **NC-AI-003**: AI Governance Policy Template (Coming Soon)
- **NC-AI-004**: AI Vendor Assessment Tool (Coming Soon)

### Additional Resources

- **ISO 42001**: Official standard available from ISO
- **ISO 23894**: AI risk management guidance
- **ISO 42005**: AI impact assessment guidance
- **Free Toolkits**: GSDCouncil, FairNow, others

---

## Version History

| Version | Date | Changes |
|---------|------|---------|
| 1.0 | Q1 2026 | Initial public release |

---

## License

**Public Domain** - This template is released to the public domain. You are free to:
- Use for any purpose
- Modify and adapt
- Share and redistribute
- Commercial use

Attribution appreciated but not required.

---

## Citation

If referencing this template in publications or documentation:

**Northern Cascadia Institute of AI Governance. (2026). NC-AI-001: AI Risk Register Template. Kaizen Strategic AI.**

Or simply:
**NC-AI-001: AI Risk Register Template v1.0, Northern Cascadia Institute of AI Governance, 2026**

---

## Feedback and Contributions

We welcome feedback and improvements to this template. Contact:
- **Email**: governance@kaizenstrategic.ai
- **Website**: kaizenstrategic.ai
- **Repository**: (GitHub link if published)

---

**For the latest updates and additional NC-AI standards, visit kaizenstrategic.ai/nc-ai-standards**

